#include "EventDefinition.h"
#include "event/PersistenceOptions.h"
#include "IllegalStateException.h"
#include "datatable/TableFormat.h"
#include "security/Permissions.h"

EventDefinition::EventDefinition(const AgString & name, TableFormatPtr format)
{
    init(name, format, AgString());
}

EventDefinition::EventDefinition(const AgString & name, TableFormatPtr format, const AgString & description)
{
    init(name, format, description);
}

EventDefinition::EventDefinition(const AgString & name, TableFormatPtr format, const AgString & description, const AgString & group)
{
    init(name, format, description);
    setGroup(group);
}

void EventDefinition::init(const AgString & name, TableFormatPtr format, const AgString & description)
{
    hidden = false;
    level = 0;
    synchronous = false;
    expirationPeriod = 0;
    persistenceOptions = PersistenceOptionsPtr(new PersistenceOptions());
    memoryStorageSize = 0;

    setName(name);
    setFormat(format);
    setDescription(description);
}


void EventDefinition::setFormat(TableFormatPtr format)
{
    if(format != 0) {
        format->makeImmutable(0);
    }
    this->format = format;
}

void EventDefinition::setHidden(bool hidden)
{
    this->hidden = hidden;
}

void EventDefinition::setPermissions(  PermissionsPtr perms)
{
	this->permissions = perms;
}

void EventDefinition::setExpirationPeriod(int64_t expirationPeriod)
{
    this->expirationPeriod = expirationPeriod;
}

void EventDefinition::setLevel(int level)
{
	this->level = level;
}

void EventDefinition::setSynchronous(bool synchronous)
{
    this->synchronous = synchronous;
}

TableFormatPtr EventDefinition::getFormat()
{
    return format;
}

bool EventDefinition::isHidden()
{
	return hidden;
}

PermissionsPtr EventDefinition::getPermissions()
{
	return permissions;
}

int64_t EventDefinition::getExpirationPeriod()
{
    return expirationPeriod;
}

int EventDefinition::getLevel()
{
    return level;
}

PermissionsPtr EventDefinition::getFirePermissions()
{
    return firePermissions;
}

void EventDefinition::setFirePermissions(PermissionsPtr firePermissions)
{
    this->firePermissions = firePermissions;
}

bool EventDefinition::isSynchronous()
{
    return synchronous;
}

PersistenceOptionsPtr EventDefinition::getPersistenceOptions()
{
	return persistenceOptions;
}

unsigned int EventDefinition::getMemoryStorageSize()
{
    return memoryStorageSize;
}

void EventDefinition::setMemoryStorageSize(int  memoryStorageSize)
{
    this->memoryStorageSize = memoryStorageSize;
}

Cloneable *EventDefinition::clone()
{
    assert(0);

    //TODO:
//    try
//    {
//        EventDefinition* clone = new EventDefinition(this);

//        //clone->persistenceOptions = persistenceOptions->clone();

//        return clone;
//    }
//    catch (CloneNotSupportedException ex)
//    {
//        throw new IllegalStateException(ex.getMessage(), ex);
//    }

    return 0;
}

int EventDefinition::compareTo(EventDefinition* /*defenition*/)
{
    assert(0);

    //TODO:
//    if(getIndex() != 0 || d)->getIndex() != 0) {
//        auto my = getIndex() != 0 ? getIndex() : new ::java::lang::Integer(int(0));
//        auto other = d)->getIndex() != 0 ? d)->getIndex() : new ::java::lang::Integer(int(0));
//        return other)->compareTo(my);
//    }
    return 0;
}

int EventDefinition::hashCode()
{
    assert(0);

    //int const prime = int(31);
    int result = int(1);
//    result = prime * result + ((getDescription() == 0) ? int(0) : getDescription())->hashCode());
//    result = prime * result + static_cast< int >((expirationPeriod ^ (static_cast<int64_t>(static_cast<uint64_t>(expirationPeriod) >> int(32)))));
//    result = prime * result + ((format == 0) ? int(0) : format)->hashCode());
//    result = prime * result + ((getGroup() == 0) ? int(0) : getGroup())->hashCode());
//    result = prime * result + ((getHelp() == 0) ? int(0) : getHelp())->hashCode());
//    result = prime * result + (hidden ? int(1231) : int(1237));
//    result = prime * result + ((getIconId() == 0) ? int(0) : getIconId())->hashCode());
//    result = prime * result + ((getIndex() == 0) ? int(0) : getIndex())->hashCode());
//    result = prime * result + level;
//    result = prime * result + ((getName() == 0) ? int(0) : getName())->hashCode());
//    result = prime * result + ((permissions == 0) ? int(0) : permissions)->hashCode());
//    result = prime * result + ((firePermissions == 0) ? int(0) : firePermissions)->hashCode());
    return result;
}

bool EventDefinition::equals(EventDefinition* other)
{
    //TODO:
    if(this == other)
        return true;

    if(other == 0)
        return false;

    if (getDescription() != other->getDescription())
        return false;

    if(expirationPeriod != other->expirationPeriod)
        return false;

    if(format == 0) {
        if (other->format != 0)
            return false;

    }else if(!format->equals(other->format.get()))
        return false;

    if( getGroup()!=other->getGroup())
        return false;

    if( getHelp()!=other->getHelp())
        return false;

    if (hidden != other->hidden)
        return false;

    if (getIconId() != other->getIconId())
        return false;

    if (getIndex()!=other->getIndex())
        return false;

    if (level != other->level)
        return false;

    if (getName() != other->getName())
        return false;

    if (permissions == 0) {
        if (other->permissions != 0)
            return false;

    }else if(!permissions->equals(other->permissions.get()))
        return false;

    if (firePermissions == 0) {
        if (other->firePermissions != 0)
            return false;

    }else if(!firePermissions->equals(other->firePermissions.get()))
        return false;

    return true;
}

