#ifndef EntityListH
#define EntityListH

#include "context/EntityReference.h"
#include "datatable/DataRecord.h"
#include "datatable/DataTable.h"
#include "datatable/TableFormat.h"
#include "util/Cloneable.h"

class EntityList: public Cloneable
{
private:

	std::list<EntityReferencePtr>  entities;
    static TableFormatPtr FORMAT_;

public:
    static AgString FIELD_CONTEXT() { return "context"; }
    static AgString FIELD_ENTITY() { return "entity"; }
	bool includes(EntityReferencePtr ref);
    bool includes(const AgString & context, const AgString & entity);
	DataTablePtr toDataTable();
    bool isEmpty();
    void add(const AgString & context, const AgString & entity);
    void add(EntityReferencePtr ref);
	std::list<EntityReferencePtr>   getEntities();
    std::list<EntityReferencePtr>::iterator iteratorBegin();
    std::list<EntityReferencePtr>::iterator iteratorEnd();
    AgString toString();
    Cloneable* clone();
    int hashCode();
    bool equals(EntityList* obj);


    EntityList();
    EntityList(DataTablePtr data);
    EntityList(const AgString & context, const AgString & entity);
    EntityList(EntityReferencePtr ref);

    static TableFormatPtr FORMAT();

};
#endif
