#ifndef DefaultContextEventListenerH
#define DefaultContextEventListenerH

#include "event/ContextEventListener.h"
#include "util/Pointers.h"


class DefaultContextEventListener : public ContextEventListener
{
private:
    CallerControllerPtr callerController;
    int  listenerCode;
    ExpressionPtr filter;
    bool acceptEventsWithoutListenerCode;
    EvaluatorPtr evaluator;

public:
    bool shouldHandle(EventPtr ev);
    CallerControllerPtr getCallerController();
    int  getListenerCode();
    void setCallerController(CallerControllerPtr callerController);

protected:
    void setAcceptEventsWithoutListenerCode(bool acceptEventsWithoutListenerCode);

public:
    void setFilter(ExpressionPtr filter);
    ExpressionPtr getFilter();

    virtual AgString toString();
    virtual bool equals(AgObject* obj);

    DefaultContextEventListener();
    DefaultContextEventListener(CallerControllerPtr callerController);
    DefaultContextEventListener(CallerControllerPtr callerController, int  listenerCode);
	DefaultContextEventListener(CallerControllerPtr callerController, int  listenerCode, ExpressionPtr filter);
	DefaultContextEventListener(int  listenerCode);
};
#endif
