#ifndef ContextVisitorH
#define ContextVisitorH

#include "context/Context.h"
#include <boost/shared_ptr.hpp>

class ContextVisitor
{
 public:
    virtual bool shouldVisit(Context* context) = 0;
    virtual void visit(Context* context) = 0;
};

class NewContextVisitor : public ContextVisitor
{
private:
    Context* context_;
    Context* child_;
public:
    NewContextVisitor(Context* context, Context* child)
    {
        this->context_ = context;
        this->child_ = child;
    }
    virtual bool shouldVisit(Context* /*context*/)
    {
        return true;
    }

    virtual void visit(Context* /*context*/)
    {
        context_->getContextManager()->contextRemoved(child_);
    }
};

#endif
