#ifndef CallerControllerH
#define CallerControllerH

#include <string>
#include <map>
#include <boost/shared_ptr.hpp>
#include "util/Pointers.h"
#include "util/AgObject.h"

class CallerController : public AgObject
{
public:
    virtual AgString getUsername() = 0;
    virtual AgString getInheritedUsername() = 0;
    virtual AgString getEffectiveUsername() = 0;
    virtual bool isPermissionCheckingEnabled() = 0;
	virtual PermissionsPtr getPermissions() = 0;
	virtual PermissionCachePtr getPermissionCache() = 0;
    virtual bool isLoggedIn()= 0;
    virtual void login(const AgString& username, const AgString& inheritedUsername, PermissionsPtr permissons) = 0;
    virtual void logout() = 0;
    virtual bool isHeadless() = 0;
    virtual AgString getType() = 0;
    virtual AgString getAddress() = 0;
    virtual AgDate getCreationTime() = 0;
    virtual CallerDataPtr getCallerData() = 0;
    virtual std::map<AgString, AgString> getProperties() = 0;
    virtual void sendFeedback(int level, const AgString& message) = 0;
};

#endif

