#ifndef AbstractEntityDefinitionH
#define AbstractEntityDefinitionH

#include "EntityDefinition.h"
#include "util/simpleobject/AgString.h"

class AbstractEntityDefinition : public EntityDefinition
{

protected:
    AgString name;
    AgString description;
    AgString help;
    AgString group;
    int index;
    AgString iconId;
    AgObjectPtr owner;

public:
    AbstractEntityDefinition();
    AgString &getName();
    void setName(const AgString &name);
    void setDescription(const AgString &description);
    void setHelp(const AgString & help);
    void setGroup(const AgString & group);
    AgString &getDescription();
    AgString &getHelp();
    AgString &getGroup();
    int getIndex() const;
    void setIndex(int index);
    void setIconId(const AgString &iconId);
    AgString &getIconId();
    AgObjectPtr getOwner();
    void setOwner(AgObjectPtr owner);
    virtual AgString toString();
    virtual bool isHeadless();
    virtual PermissionsPtr getPermissions();
    AgString toDetailedString();
};
#endif
