#include "context/AbstractEntityDefinition.h"

AbstractEntityDefinition::AbstractEntityDefinition() : index(0)
{
}

AgString &AbstractEntityDefinition::getName()
{
    return name;
}

void AbstractEntityDefinition::setName(const AgString & name)
{
    this->name = name;
}

void AbstractEntityDefinition::setDescription(const AgString & description)
{
    this->description = description;
}

void AbstractEntityDefinition::setHelp(const AgString & help)
{
    this->help = help;
}

void AbstractEntityDefinition::setGroup(const AgString & group)
{
    this->group = group;
}

AgString &AbstractEntityDefinition::getDescription()
{
    return description;
}

AgString &AbstractEntityDefinition::getHelp()
{
    return help;
}

AgString &AbstractEntityDefinition::getGroup()
{
    return group;
}

int AbstractEntityDefinition::getIndex() const
{
    return index;
}

void AbstractEntityDefinition::setIndex(int index)
{
    this->index = index;
}

void AbstractEntityDefinition::setIconId(const AgString & iconId)
{
    this->iconId = iconId;
}

AgString &AbstractEntityDefinition::getIconId()
{
    return iconId;
}

AgObjectPtr AbstractEntityDefinition::getOwner()
{
    return owner;
}

void AbstractEntityDefinition::setOwner(AgObjectPtr owner)
{
    this->owner = owner;
}

AgString AbstractEntityDefinition::toString()
{
  return description.empty() == false ? description : name;
  
}

bool AbstractEntityDefinition::isHeadless()
{
    return false;
}

PermissionsPtr AbstractEntityDefinition::getPermissions()
{
    return PermissionsPtr();
}

AgString AbstractEntityDefinition::toDetailedString()
{
   return description.empty() == false ? description + " (" + name + ")" : name;
}




