#pragma once

#include "util/AgObject.h"
#include "util/Pointers.h"
#include <boost/thread.hpp>
#include <boost/thread/condition_variable.hpp>

class  ReplyMonitor : public AgObject
{
 private:
    CommandPtr command;
    CommandPtr reply;
    boost::posix_time::ptime startTime;
    boost::posix_time::ptime time;
    boost::mutex lock;
    boost::condition_variable commandReceivedCondition;
    bool timeoutReset;
	bool terminated;
	
	bool reply_is_done;
public:

	CommandPtr getCommand();
	CommandPtr getReply();
	void setReply(CommandPtr reply);
	void terminate();
	void reset();
	bool waitReply(int64_t timeout);
    boost::posix_time::ptime getTime();
    boost::posix_time::ptime getStartTime();

	ReplyMonitor(CommandPtr command);
    AgString toString();
};
