#pragma once

#include "communication/Command.h"
#include "communication/ReplyMonitor.h"
#include "util/Pointers.h"


class CommandProcessorStatistics
{

private:
    static TableFormatPtr FORMAT;
    boost::posix_time::ptime startTime;
	int64_t commandCount;	
	int64_t outgoingTraffic;
	int64_t incomingTraffic;
	int64_t unrepliedCommandCount;
    float averageResponseTime;


    static TableFormatPtr initFORMAT();

public:
    void update(ReplyMonitorPtr monitor);
	DataTablePtr toDataTable();
    boost::posix_time::ptime getStartTime();
    boost::posix_time::time_duration getConnectionTime();
    int64_t getCommandCount();
	int64_t getAverageResponseTime();
	int64_t getOutgoingTraffic();
	int64_t getIncomingTraffic();
    int64_t getUnrepliedCommandCount();
    CommandProcessorStatistics();

};
