
#ifndef AbstractCommandParserH
#define AbstractCommandParserH

#include "communication/CommandParser.h"
#include <vector>
#include <boost/thread.hpp>

class AbstractCommandParser: public CommandParser
{

private:
    std::vector<unsigned char> data;
    CommandParserListener* listener;
    boost::mutex mutex;

public:
	void reset();
    std::vector<unsigned char> &getData();
	void addData(int dataByte);
    void setListener(CommandParserListener* listener);
    CommandParserListener* getListener();
    AgString toString();

	AbstractCommandParser();

};
#endif
