#include "communication/CommandParserListener.h"
#include "communication/AbstractCommandParser.h"
#include "util/simpleobject/AgString.h"
#include "IOException.h"
#include <boost/thread/lock_guard.hpp>

AbstractCommandParser::AbstractCommandParser()
{
    listener = NULL;
}

void AbstractCommandParser::reset()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    data.clear();
}

std::vector<unsigned char> &AbstractCommandParser::getData()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    return data;
}

void AbstractCommandParser::addData(int dataByte)
{
    boost::lock_guard<boost::mutex> lock(mutex);
    data.push_back((unsigned char)dataByte);
}

void AbstractCommandParser::setListener(CommandParserListener* listener)
{
    this->listener = listener;
}

CommandParserListener* AbstractCommandParser::getListener()
{
    return listener;
}

AgString AbstractCommandParser::toString()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    return AgString::fromBytes(data, ASCII_CHARSET);
}



