#pragma once

#include "util/Interface.h"
#include <map>

class ReferenceListener : public Interface
{
public:

	virtual void referenceChanged(ReferencePtr cause, const std::map<AgString, AgObjectPtr>& environment,
								  ChangeCachePtr cache) = 0 ;

	virtual void referenceChanged(ReferencePtr cause, const std::map<AgString, AgObjectPtr>& environment,
								  ChangeCachePtr cache, bool asynchronousProcessing) = 0;
    virtual BindingProcessor* getBindingProcessor() = 0;
	virtual BindingPtr getBinding() = 0;
	virtual EvaluationOptionsPtr getEvaluationOptions() = 0;
    virtual void setContent(AgObjectPtr content) = 0;
    virtual AgObjectPtr getContent() = 0;
};
