#pragma once

#include "util/Cloneable.h"
#include "util/Pointers.h"

class EvaluationOptions : public Cloneable
{
private:
    int pattern;
    int64_t period;
	ReferencePtr activator;
    ExpressionPtr condition;

	void init(bool startup, bool event, int64_t period);
	void init(bool startup, const AgString & activator);

public:
    static const int STARTUP = 1;
    static const int EVENT = 2;
    static const int PERIODIC = 4;

    int getPattern();
    int64_t getPeriod();
	ReferencePtr getActivator();
    ExpressionPtr getCondition();
    void setPattern(int pattern);
    void setPeriod(int64_t period);
	void setActivator(ReferencePtr activator);
    void setCondition(ExpressionPtr condition);
    bool isProcessOnStartup();
    bool isProcessOnEvent();
    bool isProcessPeriodically();
    void setProcessOnStartup(bool processOnStartup);
    void setProcessOnEvent(bool processOnEvent);
    void setProcessPeriodically(bool processPeriodically);
    Cloneable* clone();
    AgString toString();

    EvaluationOptions();
    EvaluationOptions(bool startup, bool event);
    EvaluationOptions(bool startup, bool event, int64_t period);
    EvaluationOptions(int pattern);
    EvaluationOptions(bool startup, const AgString & activator, const AgString & condition);
    EvaluationOptions(bool startup, const AgString & activator);
};
