#pragma once

#include "util/simpleobject/AgString.h"
#include "util/Pointers.h"

class BindingEventsHelper
{
private:
    static AgString executionTypeDescription(int method);

    static TableFormatPtr EFT_BINDING_EXECUTION_();
    static TableFormatPtr EFT_BINDING_EXECUTION_EXT_();
    static TableFormatPtr EFT_BINDING_ERROR_();
    static TableFormatPtr EFT_BINDING_ERROR_EXT_();

public:
    static AgString E_BINDING_ERROR() { return "bindingError"; }
    static AgString E_BINDING_EXECUTION() { return "bindingExecution"; }

    static AgString EF_BINDING_CONTEXT() { return "context"; }
    static AgString EF_BINDING_TARGET() { return "target"; }
    static AgString EF_BINDING_EXPRESSION() { return "expression"; }
    static AgString EF_BINDING_ACTIVATOR() { return "activator"; }
    static AgString EF_BINDING_EXECUTION() { return "execution"; }
    static AgString EF_BINDING_CONDITION() { return "condition"; }
    static AgString EF_BINDING_VALUE() { return "value"; }
    static AgString EF_BINDING_CAUSE() { return "cause"; }
    static AgString EF_BINDING_ERROR() { return "error"; }
    static AgString EF_BINDING_ERROR_STACK() { return "stack"; }

    static TableFormatPtr EFT_BINDING_EXECUTION;
    static TableFormatPtr EFT_BINDING_EXECUTION_EXT;
    static TableFormatPtr EFT_BINDING_ERROR;
    static TableFormatPtr EFT_BINDING_ERROR_EXT;

    static DataTablePtr createBindingErrorEventDataPtr(ContextPtr con,BindingPtr binding, int method,
                                                       const AgString & activator, AggreGateExceptionPtr error);
    static DataTablePtr createBindingExecutionEventDataPtr(ContextPtr con, int method,
                                                           BindingPtr binding,
                                                           EvaluationOptionsPtr options,
                                                           ReferencePtr cause, AgObjectPtr result);
};
