#pragma once

#include "util/Cloneable.h"
#include "util/Pointers.h"

class Binding : public Cloneable
{
public:
	Binding(ReferencePtr reference, ExpressionPtr expression);
	Binding(const AgString& reference, const AgString& expression);

	ExpressionPtr getExpression();
	ReferencePtr getReference();
    virtual Cloneable* clone();
    AgString toString();
    int64_t getId() const;
    void setId(int64_t id);

private:
	ReferencePtr reference;
	ExpressionPtr expression;
    int64_t id;
};
