#pragma once

#include "binding/BindingProvider.h"
#include "util/Pointers.h"
#include "AggreGateException.h"

class AbstractBindingProvider : public BindingProvider
{
private:
    ErrorCollectorPtr errorCollector;

public:
    virtual void processExecution(int method, BindingPtr binding, EvaluationOptionsPtr options,
                                  ReferencePtr cause, AgObjectPtr result);
    virtual void processError(BindingPtr binding, int method, ReferencePtr cause, AggreGateException error);

	AbstractBindingProvider();
    AbstractBindingProvider(ErrorCollectorPtr errorCollector);

};
