#ifndef AgentImplementationControllerH
#define AgentImplementationControllerH

#include "protocol/DefaultClientController.h"
#include "protocol/AggreGateCommand.h"
#include "context/ContextManager.h"
#include "context/AbstractContext.h"
#include "util/Pointers.h"
#include "util/BlockingChannel.h"
#include "datatable/encoding/ClassicEncodingSettings.h"

class AgentImplementationController : public DefaultClientController
{

public:
    AgentImplementationController(BlockingChannelPtr dataChannel, ContextManager *contextManager, AgObjectPtr commandExecutionService, int maxEventQueueLength);

    virtual bool controllerShouldHandle(EventPtr /*ev*/, ContextEventListener* /*listener*/);

protected:
    virtual void processMessageOperation(IncomingAggreGateCommandPtr cmd, OutgoingAggreGateCommandPtr ans);
    virtual ClassicEncodingSettingsPtr createClassicEncodingSettings(bool useFormatCache);
};

#endif
