#include "BatchContext.h"
#include "BatchEntry.h"
#include "AggreGateException.h"

void BatchContext::addBatchEntry(BatchEntryPtr batchEntry)
{
	if(batchEntry == 0)
	{
		std::cout << "Pointer = NULL!";
	}
    entries.push_back(batchEntry);
}

std::list<BatchEntryPtr> BatchContext::getEntries()
{
    return entries;
}

BatchEntryPtr BatchContext::getCurrentEntry()
{
	return currentEntry;
}

void BatchContext::markAsPerfomed(BatchEntryPtr entry)
{  
    std::list<BatchEntryPtr>::iterator itr1;
    itr1 = std::find(entries.begin(), entries.end(), entry);
    if (itr1 != entries.end())
	{
        throw AggreGateException("Entry is not on the list");
    }
    entry->setFulfilled(true);
}

void BatchContext::setCurrentEntry(BatchEntryPtr currentEntry)
{
    this->currentEntry = currentEntry;
}


