#include "action/BasicActionDefinition.h"
#include "util/Pointers.h"
#include "AggreGateException.h"

BasicActionDefinition::BasicActionDefinition(const AgString &/* name*/)
{    
}

BasicActionDefinition::BasicActionDefinition(const AgString & /*name*/, const std::string& /*actionClass*/)
{
}

void BasicActionDefinition::init()
{
    enabled = true;
    concurrent = true;
}

GroupIdentifierPtr BasicActionDefinition::getExecutionGroup()
{
    return executionGroup;
}

bool BasicActionDefinition::isEnabled()
{
    return enabled;
}

bool BasicActionDefinition::isHidden()
{
    return hidden;
}

KeyStrokePtr BasicActionDefinition::getAccelerator()
{
    return accelerator;
}

std::list<ResourceMaskPtr>  BasicActionDefinition::getDropSources()
{
    return dropSources;
}

void BasicActionDefinition::setIconId(const AgString & iconId)
{
    UNUSED(iconId);
}

void BasicActionDefinition::setHelp(const AgString & help)
{
    UNUSED(help);
}

void BasicActionDefinition::setDescription(const AgString & description)
{
    UNUSED(description);
}

void BasicActionDefinition::setExecutionGroup(const AgString & base)
{
    setExecutionGroup(GroupIdentifierPtr(new GroupIdentifier(AgString(getName()).append(GROUP_ID_SEPARATOR_()).append(base))));
}

void BasicActionDefinition::setExecutionGroup(GroupIdentifierPtr groupId)
{    
    this->executionGroup = groupId;
}

void BasicActionDefinition::setEnabled(bool enabled)
{    
    this->enabled = enabled;
}

void BasicActionDefinition::setHidden(bool hidden)
{    
    this->hidden = hidden;
}

void BasicActionDefinition::setAccelerator(KeyStrokePtr accelerator)
{    
    this->accelerator = accelerator;
}

void BasicActionDefinition::setDropSources(std::list<ResourceMaskPtr>  dropSources)
{
    if(dropSources.size() == 0) {
        throw AggreGateException("BasicActionDefinition::setDropSources Pointer = NULL");
    }
}


void BasicActionDefinition::setName(const AgString & name)
{
    AbstractEntityDefinition::setName(name);
}

bool BasicActionDefinition::isDefault()
{
    return isDefault_;
}

void BasicActionDefinition::setDefault(bool isDefault)
{
    this->isDefault_ = isDefault;
}

bool BasicActionDefinition::isConcurrent()
{
    return concurrent;
}

void BasicActionDefinition::setConcurrent(bool allowConcurrentExecution)
{
    this->concurrent = allowConcurrentExecution;
}

void BasicActionDefinition::addDropSource(ResourceMaskPtr resourceMask)
{
    if(resourceMask == 0) {
        throw AggreGateException("BasicActionDefinition::addDropSource Pointer = NULL");
    }

    dropSources.push_back(resourceMask);
}

// not used
ActionPtr BasicActionDefinition::instantiate()
{
    ActionPtr action;
    return action;
}

std::list<ActionCommandPtr>  BasicActionDefinition::getCommands()
{
    return commandList;
}

void BasicActionDefinition::registerCommands()
{
}

// not used
void BasicActionDefinition::registerCommand(ActionCommandPtr cmd)
{
    UNUSED(cmd);
}

// not used
void BasicActionDefinition::unregisterCommand(const AgString & /*id*/)
{
}

boost::mutex& BasicActionDefinition::getExecutionLock()
{
    return executionLock;
}

bool BasicActionDefinition::isHeadless()
{
    return false;
}

PermissionsPtr BasicActionDefinition::getPermissions()
{
    return PermissionsPtr();
}

int BasicActionDefinition::compareTo(Comparable* /*obj*/)
{
    return 0;
}

AgString &BasicActionDefinition::getDescription()
{
    return AbstractEntityDefinition::getDescription();
}

AgString &BasicActionDefinition::getGroup()
{
    return AbstractEntityDefinition::getGroup();
}

AgString &BasicActionDefinition::getHelp()
{
    return AbstractEntityDefinition::getHelp();
}

AgString &BasicActionDefinition::getIconId()
{
    return AbstractEntityDefinition::getIconId();
}

int BasicActionDefinition::getIndex() const
{
    return AbstractEntityDefinition::getIndex();
}

AgString &BasicActionDefinition::getName()
{
    return AbstractEntityDefinition::getName();
}

AgObjectPtr BasicActionDefinition::getOwner()
{
    return AbstractEntityDefinition::getOwner();
}

AgString BasicActionDefinition::toDetailedString()
{
    return AbstractEntityDefinition::toDetailedString();
}


