TEMPLATE			= app
CONFIG				+= console
CONFIG				-= app_bundle qt

CONFIG				+= debug_and_release

INCLUDE_DIR			= .
INCLUDEPATH			+= $${INCLUDE_DIR}/src/com/tibbo/aggregate/common
INCLUDEPATH			+= $${INCLUDE_DIR}/examples
MSVC_VERSION                    = 12.0

VPATH				= .

*-g++* {
QMAKE_CXXFLAGS_RELEASE		+= -fdata-sections -ffunction-sections -feliminate-unused-debug-types -fno-var-tracking-assignments
QMAKE_LFLAGS_RELEASE		+= -Wl,--hash-style=gnu -Wl,--as-needed -Wl,--gc-sections -Wl,--strip-all

LIBS				+= -lpthread -lssl -lcrypto -lboost_system -lboost_unit_test_framework -lboost_regex -lboost_thread -lboost_date_time -lboost_timer -lboost_chrono -llog4cpp
}

msvc {
QMAKE_CXXFLAGS_DEBUG		+= /W3 /Zi /Od /RTC1
QMAKE_CXXFLAGS_RELEASE		+= /W3 /Ox /GL

QMAKE_LFLAGS_DEBUG		+= /DEBUG
QMAKE_LFLAGS_RELEASE		+= /LTCG

INCLUDEPATH			+= $$(BOOST_DIR)
LIBS				+= -L$$(BOOST_DIR)/lib32-msvc-$${MSVC_VERSION}

INCLUDEPATH			+= $$(OPENSSL_DIR)/include
LIBS				+=-L$$(OPENSSL_DIR)/lib -llibeay32MD -lssleay32MD
#LIBS				+=-L$$(OPENSSL_DIR)/lib -lssleay32 -llibeay32

LIBS				+= -ladvapi32 -lgdi32 -lUser32
}

CONFIG(debug, debug|release) {
    ENV_NAME = debug
} else {
    ENV_NAME = release
}
include(aggregatesdk.pri)

HEADERS				+= \
				src/examples/DemoAgent.h

SOURCES				+= \
				src/examples/main.cpp \
				src/examples/DemoAgent.cpp
				#test/ApiTest.cpp \
				#test/DataTableTests.cpp \
				#test/CommandProcessorStatisticsTest.cpp \
				#test/ContextTest.cpp \
				#test/EventTest.cpp \
				#test/BlockingChannelTest.cpp
