#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTreeWidgetItem>
#include <QListWidgetItem>
#include <QFuture>
#include "util/Pointers.h"
#include "context/DefaultContextEventListener.h"

namespace Ui {
class MainWindow;
}

struct ContextInfo
{
    Context *context;
    QString description;
};

class MyEventListener : public QObject, public DefaultContextEventListener
{
    Q_OBJECT
 public:
    void handle(EventPtr event);
    AgString toString()
    {
        return "MyEventListener";
    }
 signals:
    void addLogText(const QString &text);
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

     static QString toQString(AgString &str);

private slots:
    void onConnect();
    void onCurrentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *previous);
    void onVariableDoubleClicked(QListWidgetItem * item);
    void onEventDoubleClicked(QListWidgetItem * item);
    void onAddLogText(const QString &text);

private:

    Ui::MainWindow *ui;
    RemoteServerPtr rls;
    RemoteServerControllerPtr rlc;
    QFuture<std::list<ContextInfo> > future;
    Context *curContext;
    boost::shared_ptr<MyEventListener> eventListener;

    QMap<EventDefinitionPtr, Context*> subscibedEvents;


    void addChildContexts(QTreeWidgetItem *item, Context* context);
};



#endif // MAINWINDOW_H
