#ifndef TESTAGENT_H
#define TESTAGENT_H

#include <QObject>
#include "protocol/RemoteServer.h"
#include "agent/Agent.h"
#include "agent/AgentContext.h"
#include "context/VariableGetter.h"
#include "context/VariableDefinition.h"

class TestAgent : public QObject
{
    Q_OBJECT
public:
    explicit TestAgent(QObject *parent = nullptr);
    virtual ~TestAgent();

    void initializeAgentContext();
public slots:
    void runAgent();
    void shutdown();

signals:
    void finished();

private:
    RemoteServerPtr rls;
    AgentPtr agent;
};


class TestVariableGetter : public VariableGetter
{
public :
    DataTablePtr get(Context* con, VariableDefinitionPtr def, CallerControllerPtr caller, RequestControllerPtr request);

    static std::vector<BYTE> readFile(const char *filename);
};

#endif // TESTAGENT_H
