#include <QtCore>
#include <QCoreApplication>
#include "util/Log.h"
#include "testagent.h"


int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    Log::configure(qApp->applicationDirPath().append("/logging.log4cpp_properties").toStdString());

    QThread agentThread;

    TestAgent testAgent;
    agentThread.moveToThread(&agentThread);

    QObject::connect(&testAgent, &TestAgent::finished, &agentThread, &QThread::quit);
    QObject::connect(&a, &QCoreApplication::aboutToQuit, &testAgent, &TestAgent::shutdown);
    QObject::connect(&agentThread, &QThread::finished, &a, &QCoreApplication::quit);
    QObject::connect(&agentThread, &QThread::finished, &testAgent, &TestAgent::deleteLater);
    QObject::connect(&agentThread, &QThread::started, &testAgent, &TestAgent::runAgent);
    agentThread.start();

    return a.exec();
}
