#define BOOST_TEST_DYN_LINK
#define BOOST_TEST_MODULE EventTest
#include <boost/test/unit_test.hpp>
#include "data/Event.h"
#include "datatable/DataTable.h"
#include "datatable/TableFormat.h"
#include "event/Acknowledgement.h"
#include "event/EventLevel.h"
#include "event/Enrichment.h"
#include "util/simpleobject/AgDate.h"
#include <algorithm>

BOOST_AUTO_TEST_SUITE (EventTest)

BOOST_AUTO_TEST_CASE(testEventClone)
{
    EventPtr ev = EventPtr(new Event("context", "name", EventLevel::INFO(),
                         DataTablePtr(new DataTable(TableFormatPtr(new TableFormat(1, 1, "<str><S>")), true)), 123));

    ev->addAcknowledgement( AcknowledgementPtr(new Acknowledgement("author", AgDate(), "text")) );
    ev->addAcknowledgement( AcknowledgementPtr(new Acknowledgement("author2", AgDate(), "text2")) );

    ev->addEnrichment( EnrichmentPtr(new Enrichment("xx", "yy", AgDatePtr(new AgDate()), "author")) );

    EventPtr clone = EventPtr(static_cast<Event*>(ev->clone()));

    BOOST_CHECK_EQUAL("context", clone->getContext().toUtf8());
    BOOST_CHECK_EQUAL("name", clone->getName().toUtf8());
    BOOST_CHECK_EQUAL(EventLevel::INFO(), clone->getLevel());

    std::list<AcknowledgementPtr> ls = clone->getAcknowledgements();
    std::list<AcknowledgementPtr>::iterator iter = ls.begin();
    std::advance(iter, 1);
    BOOST_CHECK_EQUAL("author2", (*iter)->getAuthor().toUtf8());

    std::list<EnrichmentPtr> ls2 = clone->getEnrichments();
    std::list<EnrichmentPtr>::iterator iter2 = ls2.begin();
    std::advance(iter2, 0);
    BOOST_CHECK_EQUAL("yy", (*iter2)->getValue().toUtf8());
}

BOOST_AUTO_TEST_SUITE_END( )


