#define BOOST_TEST_DYN_LINK
//#define BOOST_TEST_MODULE Communication
#include <boost/test/unit_test.hpp>
#include "communication/CommandProcessorStatistics.h"
#include "protocol/OutgoingAggreGateCommand.h"
#include "communication/Command.h"
#include "communication/ReplyMonitor.h"

BOOST_AUTO_TEST_SUITE (Communication)

BOOST_AUTO_TEST_CASE(testCommandProcessorStatistics)
{
    CommandProcessorStatisticsPtr s = CommandProcessorStatisticsPtr(new CommandProcessorStatistics());

    CommandPtr out = CommandPtr(new OutgoingAggreGateCommand());
    out->write(123);
    out->write(456);

    CommandPtr in = CommandPtr(new OutgoingAggreGateCommand());
    in->write(789);

    ReplyMonitorPtr rm = ReplyMonitorPtr(new ReplyMonitor(out));
    rm->setReply(in);

    boost::this_thread::sleep(boost::posix_time::milliseconds(15));

    s->update(rm);
    s->update(rm);
    s->update(rm);

    BOOST_CHECK_EQUAL(3, s->getCommandCount());

    float rt = s->getAverageResponseTime();
    BOOST_ASSERT(rt > 10.0);
    BOOST_ASSERT(rt < 1000.0);

    BOOST_CHECK_EQUAL(6, s->getOutgoingTraffic());
    BOOST_CHECK_EQUAL(3, s->getIncomingTraffic());
}

BOOST_AUTO_TEST_SUITE_END( )
