#include "util/simpleobject/AgLong.h"
#include "util/simpleobject/AgString.h"
#include <boost/lexical_cast.hpp>


AgLong::AgLong(int64_t val)
{
    value = val;
}

int64_t AgLong::getValue()
{
    return value;
}

int AgLong::compareTo(Comparable *obj)
{
    AgLong *other = static_cast<AgLong *>(obj);
    if (value == other->value)
        return 0;
    else if (value < other->value)
        return -1;
    else
        return 1;
}

std::string AgLong::getClass()
{
    return typeid(AgLong).name();
}

int AgLong::hashCode()
{
    //not used
    assert(0);
    return 0;
}

bool AgLong::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgLong *other = dynamic_cast<AgLong *>(obj);
    if (!other)
    {
        return false;
    }

    return value == other->value;
}

AgString AgLong::toString()
{
    AgString str = boost::lexical_cast<std::string>(value).c_str();
    return str;
}

Cloneable *AgLong::clone()
{
    return new AgLong(value);
}
