#include "util/simpleobject/AgColor.h"
#include "util/simpleobject/AgString.h"
#include <stdio.h>
#include <boost/functional/hash.hpp>

#define ColorLOBYTE(w)           ((uint8_t)(((uint32_t)(w)) & 0xff))
#define ColorGetRValue(rgb)      (ColorLOBYTE(rgb))
#define ColorGetGValue(rgb)      (ColorLOBYTE(((uint16_t)(rgb)) >> 8))
#define ColorGetBValue(rgb)      (ColorLOBYTE((rgb)>>16))

AgColor::AgColor()
{
    r = 0;
    g = 0;
    b = 0;
}

AgColor::AgColor(unsigned char r, unsigned char g, unsigned char b)
{
    this->r = r;
    this->g = g;
    this->b = b;
}

AgColor::AgColor(uint32_t value)
{
	this->r = ColorGetRValue(value);
    this->g = ColorGetGValue(value);
    this->b = ColorGetBValue(value);
}

int AgColor::compareTo(Comparable *obj)
{
    assert(0);
    AgColor *other = static_cast<AgColor *>(obj);
    if (r == other->r && g == other->g && b == other->b)
        return 0;
    else
    {
        return 1;
    }
}

std::string AgColor::getClass()
{
    return typeid(AgColor).name();
}

int AgColor::hashCode()
{
    char s[4];
    s[0] = r;
    s[1] = g;
    s[2] = b;
    s[3] = '\0';
    boost::hash<std::string> string_hash;
    return string_hash(s);
}

bool AgColor::equals(AgObject *obj)
{
    if (obj == NULL)
        return false;

    if (obj == this)
        return true;

    AgColor *other = dynamic_cast<AgColor *>(obj);
    if (!other)
    {
        return false;
    }

    return (r == other->r && g == other->g && b == other->b);
}

AgString AgColor::toString()
{
    char str[256];
    sprintf(str, "#%02x%02x%02x", r, g, b);
    return str;
}

Cloneable *AgColor::clone()
{
    return new AgColor(r, g, b);
}

