#pragma once
 
#include <string>
#include <list>
#include <map>
#include <vector>
#include <sstream>
#include <iostream>
#include <chrono>


#include "util/Pointers.h"
#include "util/simpleobject/AgDouble.h"
#include "util/simpleobject/AgFloat.h"
#include "util/simpleobject/AgInteger.h"
#include "util/simpleobject/AgLong.h"

using namespace std::chrono;

class Util
{

public:    
    static bool equals(std::vector< std::pair<AgObjectPtr,AgString> > &l, std::vector< std::pair<AgObjectPtr,AgString> > &r);
    static bool equals(ExpressionPtr &l, ExpressionPtr &r);
    static bool equals(TableFormatPtr &l, TableFormatPtr &r);
    static bool equals(DataRecordPtr &l, DataRecordPtr &r);
    static bool equals(AgObjectPtr &l, AgObjectPtr &r);

    static std::vector<char> readStream(std::iostream& is) ;
    static AgObject* convertToNumber(AgObjectPtr value, bool validate, bool allowNull);

    static bool convertToBoolean(AgObjectPtr value, bool validate, bool allowNull);    
    static AgString getObjectDescription(AgObjectPtr o);
    static int parseVersion(const AgString& version);
    static AgString nameToDescription(const AgString& name);
    static AgString descriptionToName(const AgString& value);
    static unsigned int getAvailableProcessors();
    static milliseconds getCurrentMilliseconds();
}; 
