#pragma once

#include <list>
#include "util/Cloneable.h"
#include "util/simpleobject/AgString.h"

class UserSettings : public Cloneable
{
private:
	AgString datePattern;
	AgString timePattern;
	AgString timeZone;
    int weekStartDay;
	std::list< EntityRelatedActionDescriptorPtr >  variableActions;
	std::list< EntityRelatedActionDescriptorPtr >  eventActions;

public:
    AgString getDatePattern();
    void setDatePattern(const AgString & datePattern);
    AgString getTimePattern();
    void setTimePattern(const AgString & timePattern);
    AgString getDateTimePattern();
    AgString getTimeZone();
    void setTimeZone(const AgString & timeZone);
    int getWeekStartDay();
    void setWeekStartDay(int weekStartDay);
	std::list< EntityRelatedActionDescriptorPtr >  getVariableActions();
	void setVariableActions(std::list <EntityRelatedActionDescriptorPtr>  variableActions);
	std::list< EntityRelatedActionDescriptorPtr >  getEventActions();
	void setEventActions(std::list< EntityRelatedActionDescriptorPtr >  eventActions);
    virtual Cloneable* clone();
    void fill(ContextManager* cm, CallerControllerPtr callerController);
    void fillBasicProperties(ContextManager* cm, CallerControllerPtr callerController);
    void fillActions(ContextManager* cm, CallerControllerPtr callerController);

	UserSettings();
    UserSettings(ContextManager* cm, CallerControllerPtr callerController);
};
