#include "util/UserSettings.h"
#include "context/Contexts.h"
#include "context/ContextUtils.h"
#include "data/User.h"
#include "server/EditableChildContextConstants.h"
#include "util/DateUtils.h"

UserSettings::UserSettings()
{
     weekStartDay = 2;//Calendar.MONDAY
}

UserSettings::UserSettings(ContextManager* cm, CallerControllerPtr callerController)
{
    weekStartDay = 2;//Calendar.MONDAY
    fill(cm, callerController);
}

void UserSettings::fill(ContextManager* cm, CallerControllerPtr callerController) /* throws(ContextException, RemoteDeviceErrorException) */
{
    fillBasicProperties(cm, callerController);
    fillActions(cm, callerController);
}

void UserSettings::fillBasicProperties(ContextManager* /*cm*/, CallerControllerPtr /*callerController*/) /* throws(ContextException, RemoteDeviceErrorException) */
{
    assert(0);
}

void UserSettings::fillActions(ContextManager* /*cm*/, CallerControllerPtr /*callerController*/)
{
    assert(0);
}

AgString UserSettings::getDatePattern()
{
    return (datePattern.length() > 0) ? datePattern : DateUtils::DEFAULT_DATE_PATTERN();
}

void UserSettings::setDatePattern(const AgString & datePattern)
{
	this->datePattern = datePattern;
}

AgString UserSettings::getTimePattern()
{
    return timePattern;
}

void UserSettings::setTimePattern(const AgString & timePattern)
{
    this->timePattern = timePattern;
}

AgString UserSettings::getDateTimePattern()
{
    assert(0);
    return "";
}

AgString UserSettings::getTimeZone()
{
    return timeZone;
}

void UserSettings::setTimeZone(const AgString & timeZone)
{
    this->timeZone = timeZone;
}

int UserSettings::getWeekStartDay()
{
    return weekStartDay;
}

void UserSettings::setWeekStartDay(int weekStartDay)
{
    this->weekStartDay = weekStartDay;
}

std::list< EntityRelatedActionDescriptorPtr >  UserSettings::getVariableActions()
{
    return variableActions;
}

void UserSettings::setVariableActions(std::list< EntityRelatedActionDescriptorPtr >  variableActions)
{
    this->variableActions = variableActions;
}

std::list<EntityRelatedActionDescriptorPtr>  UserSettings::getEventActions()
{
    return eventActions;
}

void UserSettings::setEventActions(std::list<EntityRelatedActionDescriptorPtr> eventActions)
{
    UNUSED(eventActions);
}

Cloneable *UserSettings::clone()
{
    assert(0);

    return 0;
}

