#pragma once

#include "util/TimeUnit.h"
#include <list>


class TimeUnitsManager
{
private:
    int minUnit;
    int maxUnit;
    std::list<TimeUnit>  units;

private:
    void selectUnits();
    void parseEditorOptions(const AgString & editorOptions);

public:
    int getMinUnit();
    std::list<TimeUnit> getUnits();
    void setMinUnit(int minUnit);
    int getMaxUnit();
    void setMaxUnit(int maxUnit);
    AgString createTimeString(int64_t period) const;

    TimeUnitsManager();
    TimeUnitsManager(const AgString & editorOptions);
    TimeUnitsManager(int minUnit, int maxUnit);
};
