#include "util/TimeUnitsManager.h"
#include "util/TimeHelper.h"
#include "util/simpleobject/AgString.h"
#include "util/StringUtils.h"
#include <limits>
#include <climits>


TimeUnitsManager::TimeUnitsManager()
{
    this->minUnit = 0;
    this->maxUnit = INT_MAX;
}

TimeUnitsManager::TimeUnitsManager(const AgString & editorOptions)
{
    if (editorOptions.length() > 0) {
        parseEditorOptions(editorOptions);
    }

    selectUnits();
}

TimeUnitsManager::TimeUnitsManager(int minUnit, int maxUnit)
{
    this->minUnit = minUnit;
    this->maxUnit = maxUnit;

    selectUnits();
}

void TimeUnitsManager::selectUnits()
{
}

void TimeUnitsManager::parseEditorOptions(const AgString & editorOptions)
{
    std::vector<AgString> parts = StringUtils::split(editorOptions, AgChar(' '));
    if (parts.size() > 0) {
        minUnit = AgString(parts.at(0)).toInt();
    }
    if (parts.size() > 1) {
        maxUnit = AgString(parts.at(1)).toInt();
    }
}

int TimeUnitsManager::getMinUnit()
{
    return minUnit;
}

std::list<TimeUnit> TimeUnitsManager::getUnits()
{
    return units;
}

void TimeUnitsManager::setMinUnit(int minUnit)
{
    this->minUnit = minUnit;
}

int TimeUnitsManager::getMaxUnit()
{
    return maxUnit;
}

void TimeUnitsManager::setMaxUnit(int maxUnit)
{
    this->maxUnit = maxUnit;
}
