#include "util/ThreadPoolCachedEx.h"

ThreadPoolCachedEx::ThreadPoolCachedEx(const int hotThreadsParam, const int maxThreadsParam, const int timeoutParam):
    hotThreads(hotThreadsParam), maxThreads(maxThreadsParam), timeout(timeoutParam)
{
}


template <typename T>
void ThreadPoolCachedEx::submit(Callable<T>* task)
{
    task->call();
}

template <typename T>
void ThreadPoolCachedEx::submit(Runnable<T> *task)
{
    task->run();
}


ThreadPoolCachedEx::~ThreadPoolCachedEx()
{
}
