#pragma once

#include "util/ElementList.h"
#include "util/Pointers.h"
#include "util/simpleobject/AgColor.h"


#include <string>
#include <list>
#include <map>
#include <vector>
#include <set>


class StringUtils
{
public:
    static AgString DEFAULT_COLLECTION_PRINT_SEPARATOR() { return ", "; }
    static AgString DEFAULT_MAP_KEY_VALUE_SEPARATOR() { return ": "; }

    static AgString truncate(const AgString & str, int maxLength);
    static AgString truncate(const AgString & str, int maxLength, const AgString & suffix);
    static const AgString byteToHexString(int i);

    static ElementListPtr elements(const AgString & source, bool useVisibleSeparators);
    static AgString escapeHtml(const AgString & text);
    static AgString print(std::list<AgString> col);
    static AgString print(std::list<AgObjectPtr> col);
    static AgString print(std::list<AgString> col, const AgString & separator);
    static AgString print(std::list<AgString> col, const AgString & separator, bool skipNullElements);
    static AgString print(std::list<AgString> col, const AgString & separator, const AgString & escaper, bool skipNullElements);
    static AgString print(std::set<AgString> col, const AgString & separator);
    static AgString remoteNonDigits(const AgString & src);
    static AgString removeSuffix(const AgString & src, const AgString & suffix);
    static std::vector<AgString> split(const AgString & str, uint16_t ch);
    static std::vector<AgString> split(const AgString & str, uint16_t ch, int limit);
    static std::vector<AgString> splitRegExp(const AgString &s, const AgString &delim);
    //static std::vector<std::string> splitRegExp(const std::string & s, std::string rgx_str);

    static AgString streamToString(std::iostream* is);
	static std::list<AgString>  wrapText(const AgString & text, int len);
    static AgString wrapText(const AgString & text, int len, const AgString & separator);
    static AgString makeName(const AgString & source, int maxLength);
    static bool isPureAscii(const AgString & v);
    static bool isEmpty(const AgString & text);

    static AgString colorToString(AgColor &color);

	StringUtils();
};
