#include "Element.h"

   
Element::Element(const AgString &name, const AgString &value) :
	name(name), value(value)
{    
}
  
AgString& Element::getName()
{
    return name;
}
  
AgString& Element::getValue()
{
    return value;
}
  
AgString Element::encode(bool useVisibleSeparators)
{
    AgChar elStart = useVisibleSeparators ? DataTableUtils::ELEMENT_VISIBLE_START : DataTableUtils::ELEMENT_START;
    AgChar elEnd = useVisibleSeparators ? DataTableUtils::ELEMENT_VISIBLE_END : DataTableUtils::ELEMENT_END;
    AgChar elNameValSep = useVisibleSeparators ? DataTableUtils::ELEMENT_VISIBLE_NAME_VALUE_SEPARATOR : DataTableUtils::ELEMENT_NAME_VALUE_SEPARATOR;

    AgString str = elStart;
    if (!name.empty())
    {
        str += name + AgString(elNameValSep);
    }
    str += value + AgString(elEnd);

    return str;
}
