#pragma once

#include <string>
#include <map>
#include <stdint.h>
#include "Cres.h"

/**
 * This class mimics the logic of org.rrd4j.core.Datasource
 */
class ChangeProcessor
{
public:
	static int GAUGE;
	static int COUNTER;
	static int DERIVE;
	static int ABSOLUTE;
  
	static int OUT_OF_RANGE_IGNORE;
	static int OUT_OF_RANGE_DISCARD;
	static int OUT_OF_RANGE_NORMALIZE;

	static double MAX_32_BIT;
	static double MAX_64_BIT;

	ChangeProcessor(int type);
	ChangeProcessor(int type, int outOfRangeValuesHandling, double minValue, double maxValue);

	double process(int64_t newTime, double newValue);

	static std::map<int, AgString> getSelectionValues();
  
private:
	double calculateUpdateValue(int64_t oldTime, double oldValue, int64_t newTime, double newValue);

	static std::map<int, AgString> SELECTION_VALUES;
	int type;
	int outOfRangeValuesHandling;
	double minValue;
	double maxValue;
  
	int64_t lastUpdateTime;
	double lastValue;
};   
