#pragma once

namespace AlertContextConstants
{
   static const int INSTANCE_TYPE_PENDING = 0;
   static const int INSTANCE_TYPE_ACTIVE = 1;
   static const int STATUS_ENABLED = 0;
   static const int STATUS_DISABLED = 1;
   static const int STATUS_ACTIVE = 2;
   static const int STATUS_ESCALATED = 3;
   static const int CORRECTIVE_ACTION_TYPE_RISE = 0;
   static const int CORRECTIVE_ACTION_TYPE_ACTIVATION = 1;
   static const int CORRECTIVE_ACTION_TYPE_DEACTIVATION = 2;
   static const int CORRECTIVE_ACTION_TYPE_ESCALATION = 3;
   static const int CORRECTIVE_ACTION_TYPE_DEESCALATION = 4;
   static const int CORRECTIVE_ACTION_TYPE_ACKNOWLEDGEMENT = 5;

   static const AgString   V_ALERT_ACTIONS = L"alertActions";
   static const AgString   V_ESCALATION = L"escalation";
   static const AgString   V_EVENT_TRIGGERS = L"eventTriggers";
   static const AgString   V_VARIABLE_TRIGGERS = L"variableTriggers";
   static const AgString   V_STATUS = L"status";
   static const AgString   V_EVENT_TRIGGER_STATUS = L"eventTriggerStatus";
   static const AgString   V_VARIABLE_TRIGGER_STATUS = L"variableTriggerStatus";
   static const AgString   V_NOTIFICATIONS = L"notifications";
   static const AgString   V_INTERACTIVE_ACTIONS = L"interactiveActions";
   static const AgString   V_ACTIVE_INSTANCES = L"activeInstances";
   static const AgString   E_ALERT = L"alert";
   static const AgString   E_ALERTNOTIFY = L"alertnotify";
   static const AgString   E_DEACTIVATION = L"deactivation";
   static const AgString   A_PENDING_ALERTS = L"pendingAlerts";
   static const AgString   VF_ALERT_ACTIONS_EXECUTION_TYPE = L"executionType";
   static const AgString   VF_ALERT_ACTIONS_MASK = L"mask";
   static const AgString   VF_ALERT_ACTIONS_ACTION = L"action";
   static const AgString   VF_ALERT_ACTIONS_INPUT = L"input";
   static const AgString   VF_ALERT_ACTIONS_CONDITION = L"condition";
   static const AgString   VF_ALERT_ACTIONS_RUN_FROM_SOURCE = L"runFromSource";
   static const AgString   VF_INTERACTIVE_ACTIONS_EXECUTION_TYPE = L"executionType";
   static const AgString   VF_INTERACTIVE_ACTIONS_MASK = L"mask";
   static const AgString   VF_INTERACTIVE_ACTIONS_ACTION = L"action";
   static const AgString   VF_INTERACTIVE_ACTIONS_INPUT = L"input";
   static const AgString   VF_INTERACTIVE_ACTIONS_RUN_FROM_SOURCE = L"runFromSource";

   static const AgString   VF_STATUS_ENABLED = L"enabled";
   static const AgString   VF_STATUS_PENDING_INSTANCE_COUNT = L"pendingInstanceCount";
   static const AgString   VF_STATUS_MAX_PENDING_TIME = L"maxPendingTime";
   static const AgString   VF_STATUS_ESCALATED = L"escalated";
   static const AgString   VF_STATUS_ESCALATION_REASON = L"escalationReason";

   static const AgString   VF_ACTIVE_INSTANCES_EVENT = L"event";
   static const AgString   VF_ACTIVE_INSTANCES_TYPE = L"type";
   static const AgString   VF_ACTIVE_INSTANCES_TIME = L"time";
   static const AgString   VF_ACTIVE_INSTANCES_LEVEL = L"level";
   static const AgString   VF_ACTIVE_INSTANCES_SOURCE = L"source";
   static const AgString   VF_ACTIVE_INSTANCES_KEY = L"key";
   static const AgString   VF_ACTIVE_INSTANCES_CAUSE = L"cause";
   static const AgString   VF_ACTIVE_INSTANCES_MESSAGE = L"message";
   static const AgString   VF_ACTIVE_INSTANCES_TRIGGER = L"trigger";
   static const AgString   VF_ACTIVE_INSTANCES_DATA = L"data";

   static const AgString   VF_EVENT_TRIGGER_STATUS_TRIGGER = L"trigger";
   static const AgString   VF_EVENT_TRIGGER_STATUS_ACTIVE = L"active";
   static const AgString   VF_EVENT_TRIGGER_STATUS_DETAILS = L"details";

   static const AgString   VF_EVENT_TRIGGER_STATUS_DETAILS_CONTEXT = L"context";
   static const AgString   VF_EVENT_TRIGGER_STATUS_DETAILS_ACTIVE = L"active";
   static const AgString   VF_EVENT_TRIGGER_STATUS_DETAILS_EVENTS = L"events";

   static const AgString   VF_VARIABLE_TRIGGER_STATUS_TRIGGER = L"trigger";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_ACTIVE = L"active";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS = L"details";

   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS_CONTEXT = L"context";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS_KEY = L"key";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS_ACTIVE = L"active";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS_TIME = L"time";
   static const AgString   VF_VARIABLE_TRIGGER_STATUS_DETAILS_FLAPPING = L"flapping";

   static const AgString   VF_NOTIFICATIONS_NOTIFY_OWNER = L"notifyOwner";
   static const AgString   VF_NOTIFICATIONS_ACK_REQUIRED = L"ackRequired";
   static const AgString   VF_NOTIFICATIONS_LIFETIME = L"lifetime";
   static const AgString   VF_NOTIFICATIONS_SOUND = L"sound";
   static const AgString   VF_NOTIFICATIONS_MAIL_TO_OWNER = L"mailToOwner";
   static const AgString   VF_NOTIFICATIONS_MAIL_RECIPIENTS = L"mailRecipients";
   static const AgString   VF_NOTIFICATIONS_ADDITIONAL_MAIL_RECIPIENTS = L"additionalMailRecipients";
   static const AgString   VF_NOTIFICATIONS_SMS_RECIPIENTS = L"smsRecipients";
   static const AgString   VF_NOTIFICATIONS_SMS_RECIPIENTS_PHONE = L"phone";
   static const AgString   VF_NOTIFICATIONS_MAIL_RECIPIENTS_USERNAME = L"username";

   static const AgString   EF_ALERT_DESCRIPTION = L"description";
   static const AgString   EF_ALERT_CONTEXT = L"context";
   static const AgString   EF_ALERT_ENTITY = L"entity";
   static const AgString   EF_ALERT_CAUSE = L"cause";
   static const AgString   EF_ALERT_MESSAGE = L"message";
   static const AgString   EF_ALERT_TRIGGER = L"trigger";
   static const AgString   EF_ALERT_DATA = L"data";

   static const AgString   EF_DEACTIVATION_ID = L"id";
   static const AgString   EF_DEACTIVATION_CONTEXT = L"context";
   static const AgString   EF_DEACTIVATION_DURATION = L"duration";

   static const AgString   EF_ALERTNOTIFY_DESCRIPTION = L"description";
   static const AgString   EF_ALERTNOTIFY_CONTEXT = L"context";
   static const AgString   EF_ALERTNOTIFY_ENTITY = L"entity";
   static const AgString   EF_ALERTNOTIFY_CAUSE = L"cause";
   static const AgString   EF_ALERTNOTIFY_MESSAGE = L"message";
   static const AgString   EF_ALERTNOTIFY_TRIGGER = L"trigger";
   static const AgString   EF_ALERTNOTIFY_DATA = L"data";
   static const AgString   EF_ALERTNOTIFY_ALERT_EVENT_ID = L"alertEventId";
}
