#pragma once

#include "security/DefaultPermissionChecker.h"
#include <string>
#include <boost/shared_ptr.hpp>

class ServerPermissionChecker : public DefaultPermissionChecker
{
private:
    static AgString OBSERVER_PERMISSIONS_() { return "observer"; }
    static AgString OPERATOR_PERMISSIONS_() { return "operator"; }
    static AgString MANAGER_PERMISSIONS_() { return "manager"; }
    static AgString ENGINEER_PERMISSIONS_() { return "engineer"; }
    static AgString ADMIN_PERMISSIONS_() { return "admin"; }

    static PermissionsPtr getObserverPermissions();
    static PermissionsPtr getOperatorPermissions();
    static PermissionsPtr getManagerPermissions();
    static PermissionsPtr getEngineerPermissions();
    static PermissionsPtr getAdminPermissions();

    ServerPermissionChecker();
};
