#include "security/ServerPermissionChecker.h"
#include "security/PermissionType.h"
#include "Cres.h"
#include <boost/utility/binary.hpp>

ServerPermissionChecker::ServerPermissionChecker()
{
    std::vector<PermissionTypePtr> permisType;

    PermissionTypePtr nullType = PermissionTypePtr(new PermissionType(0, NULL_PERMISSIONS(), Cres::get()->getString("secNoPerms")));
    permisType.push_back( nullType );

    PermissionTypePtr observerType = PermissionTypePtr(new PermissionType( BOOST_BINARY(00000001), OBSERVER_PERMISSIONS_(), Cres::get()->getString("secObserverPerms")));
    permisType.push_back( observerType );

    PermissionTypePtr operatorType = PermissionTypePtr(new PermissionType( BOOST_BINARY(00000011), OPERATOR_PERMISSIONS_(), Cres::get()->getString("secOperatorPerms")));
    permisType.push_back( operatorType );

    PermissionTypePtr managerType = PermissionTypePtr(new PermissionType( BOOST_BINARY(00000111), MANAGER_PERMISSIONS_(), Cres::get()->getString("secManagerPerms")));
    permisType.push_back( managerType );

    PermissionTypePtr engineerType = PermissionTypePtr(new PermissionType( BOOST_BINARY(00001111), ENGINEER_PERMISSIONS_(), Cres::get()->getString("secEngineerPerms")));
    permisType.push_back( engineerType );

    PermissionTypePtr adminType = PermissionTypePtr(new PermissionType( BOOST_BINARY(00011111), ADMIN_PERMISSIONS_(), Cres::get()->getString("secAdminPerms")));
    permisType.push_back( adminType );

    setPermissionTypes( permisType );
}

PermissionsPtr ServerPermissionChecker::getObserverPermissions()
{
    return PermissionsPtr(new Permissions("", OBSERVER_PERMISSIONS_()));
}

PermissionsPtr ServerPermissionChecker::getOperatorPermissions()
{
    return PermissionsPtr(new Permissions("", OPERATOR_PERMISSIONS_()));
}

PermissionsPtr ServerPermissionChecker::getManagerPermissions()
{
    return PermissionsPtr(new Permissions("", MANAGER_PERMISSIONS_()));
}

PermissionsPtr ServerPermissionChecker::getEngineerPermissions()
{
    return PermissionsPtr(new Permissions("", ENGINEER_PERMISSIONS_()));
}

PermissionsPtr ServerPermissionChecker::getAdminPermissions()
{
    return PermissionsPtr(new Permissions("", ADMIN_PERMISSIONS_()));
}

