#pragma once

#include "security/Permission.h"
#include <string>
#include <list>
#include <boost/shared_ptr.hpp>
#include <boost/thread/mutex.hpp>

class Permissions
{
private:
    std::list<PermissionPtr>  permissions;
    boost::mutex permissionsLock;
    void ctor(const AgString& data, boost::shared_ptr<PermissionChecker> checker);

public:
    AgString encode();
    AgString toString();
    int size();
    Permissions &add(PermissionPtr permission);
	int hashCode();
    bool equals(Permissions* obj);

    std::list<PermissionPtr>::iterator iteratorBegin();
    std::list<PermissionPtr>::iterator iteratorEnd();

    Permissions();
    Permissions(const AgString& data, boost::shared_ptr<PermissionChecker> checker);
    Permissions(const AgString& context, const AgString& type);
    Permissions(const AgString& data);

    static const char PERMISSIONS_SEPARATOR = ',';

};
