#pragma once
#include "security/PermissionChecker.h"

#include <string>
#include <map>
#include <boost/shared_ptr.hpp>

class NullPermissionChecker : public PermissionChecker
{

public:
    virtual std::map<AgString, AgString> getPermissionLevels();
    virtual bool has(CallerControllerPtr caller, PermissionsPtr requiredPermissions,
                     Context* accessedContext);
    virtual bool canSee(PermissionsPtr perms, const AgString& context, ContextManager* cm);
    virtual AgString getLevel(PermissionsPtr perms, const AgString& context, ContextManager* cm);
    virtual bool isValid(const AgString& permissionLevel);
    virtual AgString canActivate(PermissionsPtr has, PermissionsPtr need,
                                    ContextManager* cm);

    NullPermissionChecker();
};
