#pragma once

#include "security/PermissionType.h"
#include "security/PermissionChecker.h"
#include "util/Pointers.h"
#include <vector>

class DefaultPermissionChecker : public PermissionChecker
{
private:
    static AgString NULL_PERMISSIONS_() { return ""; }
	std::vector< PermissionTypePtr > permissionTypes;
    CallerControllerPtr unchecked;

public:
    DefaultPermissionChecker();

    static const AgString NULL_PERMISSIONS();

    void setPermissionTypes(std::vector<PermissionTypePtr > perms);
    static PermissionsPtr getNullPermissions();
    virtual bool has(CallerControllerPtr caller, PermissionsPtr requiredPermissions,
                     Context* accessedContext);
    virtual AgString getLevel(PermissionsPtr perms, const AgString& context, ContextManager* cm);
    bool canSee(PermissionsPtr perms, const AgString& context, ContextManager* cm);
    virtual AgString canActivate(PermissionsPtr has, PermissionsPtr requiredPermissions,
                                    ContextManager* cm);
    virtual bool isValid(const AgString& permissionLevel);
    virtual std::map<AgString, AgString> getPermissionLevels();

private:
    bool hasNecessaryLevel(const AgString& existingLevel, const AgString& requiredLevel);
	int findPattern(const AgString& level);
    bool contextMatches(PermissionPtr existingPermission, PermissionPtr requiredPermission,
                        Context* accessedContext);
    std::list<AgString> getAllowedPaths(PermissionPtr permission, ContextManager* cm);
};
