#ifndef RemoteContextManagerH
#define RemoteContextManagerH

#include "context/DefaultContextManager.h"
#include "AbstractAggreGateDeviceController.h"
#include "ProxyContext.h"
#include "AggreGateDevice.h"

#include "Cres.h"
#include "event/ContextEventListener.h"
#include "expression/Expression.h"
#include "protocol/AbstractAggreGateDeviceController.h"
#include "protocol/AggreGateCommandUtils.h"
#include "protocol/ProxyContext.h"

class RemoteContextManager : public DefaultContextManager
{

private:
	bool initialized;
	bool initializing;
    AbstractAggreGateDeviceController* controller;

	void init();

    void sendAddListener(const AgString & context, const AgString & event, ContextEventListenerPtr listener);
    void sendRemoveListener(const AgString & context, const AgString & event, ContextEventListenerPtr listener);

public:
    RemoteContextManager(AbstractAggreGateDeviceController* controller, AggreGateDevice* server, bool async);

	void initialize();


    virtual void stop();
    AbstractAggreGateDeviceController* getController();

    void addListenerToContext(ProxyContextPtr con, const AgString & event, ContextEventListenerPtr listener, bool mask, bool weak);
    void addListenerToContext(ContextPtr con, const AgString & event, ContextEventListenerPtr listener, bool mask, bool weak);

    void removeListenerFromContext(ProxyContextPtr con, const AgString & event, ContextEventListenerPtr listener, bool mask);
    void removeListenerFromContext(ContextPtr con, const AgString & event, ContextEventListenerPtr listener, bool mask);
    void addMaskEventListener(const AgString & mask, const AgString & event, ContextEventListenerPtr listener);
    void removeMaskEventListener(const AgString & mask, const AgString & event, ContextEventListenerPtr listener);
	void contextRemoved(ProxyContextPtr con);
    void contextRemoved(ContextPtr con);
};

#endif
