#ifndef OutgoingAggreGateCommandH
#define OutgoingAggreGateCommandH

#include "AggreGateCommand.h"
#include "util/simpleobject/AgString.h"

class OutgoingAggreGateCommand : public AggreGateCommand
{
private:
    int paramCount;
    AgString id;

protected:
    virtual AgString header();
    virtual AgString footer();

public:
    OutgoingAggreGateCommand();
    OutgoingAggreGateCommand& addParam(const AgString & param);
    virtual AgString getId();
    void constructReply(const AgString & id, const AgString & code);
    void constructReply(const AgString & id, const AgString & code, const AgString & message);
    void constructReply(const AgString & id, const AgString & code, const AgString & message, const AgString & details);
    void constructEvent(const AgString & context, const AgString & name, int level, const AgString & encodedDataTable, int64_t  eventId, AgDatePtr creationtime, int  listener);

};

#endif
