#ifndef IncomingAggreGateCommandH
#define IncomingAggreGateCommandH

#include "AggreGateCommand.h"
#include <vector>

class IncomingAggreGateCommand : public AggreGateCommand
{
private:
    static AgString EMPTY_ID() { return ""; }
    std::vector<AgString> parameters;

protected:
    void parse();

public:
    IncomingAggreGateCommand(const unsigned char *data, int len);
    IncomingAggreGateCommand(const AgString &str);
    IncomingAggreGateCommand(const std::vector<unsigned char>& data);

    int getNumberOfParameters();
    bool hasParameter(int number);
    AgString &getParameter(int number);
    std::vector<AgString> &getParameters(int number);
    bool isReply();
    bool isMessage();
    AgString getReplyCode();
    AgString getMessageCode();
    AgString getEncodedDataTable(int index) ;
    AgString getEncodedDataTableFromReply() ;
    AgString getEncodedDataTableFromOperationMessage() ;
    AgString getEncodedDataTableFromEventMessage() ;
    virtual AgString getId();
    virtual bool isAsync();


};
#endif
