#include "AggreGateNetworkDevice.h"
#include "util/simpleobject/AgString.h"

AggreGateNetworkDevice::AggreGateNetworkDevice()
    : AggreGateDevice()
{
    init();
    this->connectionTimeout = AggreGateNetworkDevice::DEFAULT_CONNECTION_TIMEOUT();
}

AggreGateNetworkDevice::AggreGateNetworkDevice(AgString address, int port)
    : AggreGateDevice()
{
    init();
    this->connectionTimeout = AggreGateNetworkDevice::DEFAULT_CONNECTION_TIMEOUT();
    this->address = address;
    this->port = port;
}

void AggreGateNetworkDevice::init()
{
    port = 0;
    id = "network";
    type = "Generic AggreGate Network Device";
}

AgString AggreGateNetworkDevice::getAddress()
{
    return address;
}

int AggreGateNetworkDevice::getPort()
{
    return port;
}

void AggreGateNetworkDevice::setPort(int port)
{
    this->port = port;
}

void AggreGateNetworkDevice::setAddress(AgString address)
{
  this->address = address;
}

int64_t AggreGateNetworkDevice::getConnectionTimeout()
{
    return connectionTimeout;
}

void AggreGateNetworkDevice::setConnectionTimeout(int64_t connectionTimeout)
{
    this->connectionTimeout = connectionTimeout;
}

AgString AggreGateNetworkDevice::getInfo()
{
   return (address + AgString::fromInt(port));
}

int AggreGateNetworkDevice::hashCode()
{
    assert(0);
	return 0;
}

bool AggreGateNetworkDevice::equals(AgObject *obj)
{	
    if( obj == NULL) {
        return true;
    }

    AggreGateNetworkDevice* other = dynamic_cast<AggreGateNetworkDevice*>(obj);
    if( this == obj) {
        return true;
    }

    if (!AggreGateDevice::equals(obj))
    {
        return false;
    }

    if (address != other->address) {
        return false;
    }

    if (port != other->port) {
        return false;
	}

	return true;
}



