#include "protocol/AggreGateCommand.h"
#include "util/simpleobject/AgString.h"
#include <boost/thread/locks.hpp>

static const int MAX_PRINTED_LENGTH = 1000;
const AgChar CLIENT_COMMAND_SEPARATOR = AgChar(0x0017);
int AggreGateCommand::GENERATED_ID = 0;
boost::mutex AggreGateCommand::mutex;

AgString AggreGateCommand::toString()
{
    AgString s = Command::toString();

    int len = s.length();

    s = s.substr(0, std::min<int>(MAX_PRINTED_LENGTH, s.length()));

    if (s.length() >= MAX_PRINTED_LENGTH)
    {
        s += "... (" + AgString::fromInt(len) + ")";
    }

    s.replaceStr(AgString(CLIENT_COMMAND_SEPARATOR), "/");

    s.replaceStr(AgString(DataTableUtils::ELEMENT_START), AgString(DataTableUtils::ELEMENT_VISIBLE_START));
    s.replaceStr(AgString(DataTableUtils::ELEMENT_END), AgString(DataTableUtils::ELEMENT_VISIBLE_END));
    s.replaceStr(AgString(DataTableUtils::ELEMENT_NAME_VALUE_SEPARATOR), AgString(DataTableUtils::ELEMENT_VISIBLE_NAME_VALUE_SEPARATOR));

    s.replaceStr(AgString(DataTableUtils::DATA_TABLE_NULL), AgString(DataTableUtils::DATA_TABLE_VISIBLE_NULL()));

    return s;
}

const AgString AggreGateCommand::generateId()
{
    boost::lock_guard<boost::mutex> lock(mutex);
    return AgString::fromInt(++GENERATED_ID);
}
