
#ifndef AbstractClientControllerH
#define AbstractClientControllerH

#include "context/CallerData.h"

class AbstractClientController : public CallerData
{

private:
    ContextManager* contextManager;
    CallerControllerPtr callerController;
    boost::mutex listenersMutex;
    std::map< AgString, std::map<AgString, ContextEventListenerSetPtr> > listeners;

public:
    CallerControllerPtr getCallerController();
    void setCallerController(CallerControllerPtr callerController);
    void addMaskListener(const AgString & context, const AgString & name, ContextEventListenerPtr cel, bool weak);
    void removeMaskListener(const AgString & context, const AgString & name, ContextEventListenerPtr cel);
    ContextManager* getContextManager();
    void shutdown();


    AbstractClientController();
    AbstractClientController(ContextManager* contextManager);
    AbstractClientController(ContextManager* contextManager, CallerControllerPtr callerController);

};

#endif
