#pragma once

#include "plugin/AggreGatePlugin.h"
#include <string>
#include "util/Pointers.h"
#include "util/Comparable.h"

class BasePlugin : public AggreGatePlugin, public Comparable
{
private:
	PluginDirectorPtr pluginDirector;
	AgString id;
	AgString description;
	int index;
	void init();


public:
    AgString getId();
    void setId(const AgString & id);
    AgString getShortId();
    AgString  getDescription();
    void setDescription(const AgString & description);
	PluginDirectorPtr getPluginDirector();
	void setPluginDirector(PluginDirectorPtr pluginDirector);
    int getSortIndex();

    void setIndex(int index);

    int compareTo(BasePlugin *other);

    void doStart();
    void doStop();

    static int INDEX_HIGHEST() { return 400; }
    static int INDEX_VERY_HIGH() { return 300; }
    static int INDEX_HIGH() { return 200; }
    static int INDEX_HIGHER() { return 100; }
    static int INDEX_NORMAL() { return 0; }
    static int INDEX_LOWER() { return -100; }
    static int INDEX_LOW() { return -200; }
    static int INDEX_VERY_LOW() { return -300; }
    static int INDEX_LOWEST() { return -400; }

    void globalInit(ContextPtr rootContext) ;
    void globalDeinit(ContextPtr rootContext) ;
    void userInit(ContextPtr userContext) ;
    void userDeinit(ContextPtr userContext) ;
    void globalStart() ;
	void globalStop() ;


	BasePlugin();
    BasePlugin(const AgString & description);

};
