#pragma once

#include "util/Cloneable.h"
#include "expression/Reference.h"
#include <string>
#include <boost/shared_ptr.hpp>

class Expression : public Cloneable
{

private:
    static AgString REFERENCE_START() { return "{"; }
    static AgString REFERENCE_END() { return "}"; }
    AgString text;
public:
    AgString getText();
    AgString toString();
    bool equals(Expression* obj);
    Expression* clone();

    Expression(boost::shared_ptr<Reference> reference);
	Expression(const AgString & text);
};
